#include "datamodel.h"
#include <QDebug>
#include <QSqlField>
#include <QSqlQuery>
#include <QSqlRecord>

DataModel::DataModel(QObject* parent, QSqlDatabase db)
    : QSqlTableModel(parent, db)
{
}

QHash<int, QByteArray> DataModel::roleNames() const
{
    QHash<int, QByteArray> roleNames;
    for (int i = 0; i < columnCount(); i++) {
        roleNames[Qt::UserRole + i + 1] = QVariant(headerData(i, Qt::Horizontal).toString()).toByteArray();
    }
    return roleNames;
}

QVariant DataModel::data(const QModelIndex& item, int role) const
{
    if (item.row() >= rowCount()) {
        return QVariant();
    }

    if (role < Qt::UserRole) {
        return QSqlTableModel::data(item, role);
    } else {
        return QSqlTableModel::data(this->index(item.row(), role - Qt::UserRole - 1), Qt::DisplayRole);
    }
}

QVariant DataModel::roleFromRow(int row, QString roleName)
{
    QSqlRecord rec = QSqlTableModel::record(row);
    return rec.value(roleName);
}
